#ifndef ZMODELER_RENDERBLOCK_INCLUDED
#define ZMODELER_RENDERBLOCK_INCLUDED

typedef struct
{
    float x,y,z,nx,ny,nz,u,v,u2,v2;
}Vertex2UV;


typedef struct tRenderBlock
{
  long    MaterialIndex;
  DWORD    RenderFlags;
  DWORD    WrapFlags;
  DWORD    BlendType;

  Vertex2UV  *Vertices;  //array
  long    VertAmount;
}tRenderBlock;


/////////////////////////////
// Wire drawing:
typedef struct tWireBlock
{
  Vertex2UV  *Vertices;    //full array
  Vertex2UV  *Dots;      //Dots array(Vert/Face level);
  Vertex2UV  *Lines;      //Vert level: normals
  long    AmountNormal;
  long    AmountMarked;
  long    AmountSelected;
  long    AmountSelMarked;
  long    AmountDisabled;

  long    DotsAmount;
  long    LinesAmount;
  tWireBlock()
  {
    Vertices = NULL;
    Dots = NULL;
    Lines = NULL;
    DotsAmount = 0;
    LinesAmount = 0;
    AmountNormal  = 0;
    AmountMarked  = 0;
    AmountSelected  = 0;
    AmountSelMarked  = 0;
    AmountDisabled  = 0;
  }
}tWireBlock;

#endif /*ZMODELER_RENDERBLOCK_INCLUDED*/
